#version 330 core

uniform sampler2D diffuse;
uniform sampler2D specular;

in vec3 ec_pos;
in vec2 pos_zw;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

void main()
{
	vec3 normal = normalize( cross(dFdx(ec_pos), dFdy(ec_pos)) );

	float dx = dot(vec3(1.0, 0.0, 0.0), normal);
	float dy = dot(vec3(0.0, 1.0, 0.0), normal);
	float dz = dot(vec3(0.0, 0.0, 1.0), normal);
	
	vec2 uv = (ec_pos.yz*dx + ec_pos.xz*dy + ec_pos.xy*dz) * 5.0;

	diffuse_specular.rgb = texture2D(diffuse, uv).rgb;
	diffuse_specular.a = texture2D(specular, uv).r;

	normal_depth.rgb = normal;
	normal_depth.a = pos_zw.x/pos_zw.y;
}

